# -*- coding: utf-8 -*-
"""
Created on Thu Oct 15 21:28:59 2015

@author: gareth
"""

import CMF_Hydro

import AdvectionOnly
import ADE_longitudinal_mixing
import ADE_transverse_mixing
import ADZ

class CCalculateConcentrationsModule:
    
    def __init__(self):
        self = self
        
    def CalculateAdvectionOnlyConcentrations(self):
        # extract the information from self.Analysis that it needs to calculate Avection-only Concentrations
        mass = self.Analysis.Pollutant.Mass
        area = self.Analysis.River.Area
        vx = self.Analysis.River.MeanVelocity
        
        # calculate the concentrations and return the result
        return AdvectionOnly.AdvectionOnly(mass, vx, area, self.Analysis.Domain)    
        
    def CalculateADELongitudinalConcentrations(self):
        # extract the information from self.Analysis that it needs to calculate ADE Longitudinal Concentrations
        mass = self.Analysis.Pollutant.Mass
        dx = self.Analysis.MixingParameters.Dx
        velocity = self.Analysis.River.MeanVelocity
        area = self.Analysis.River.Area
        t_settle = CMF_Hydro.CalculateSettlingTime()
        
        # calculate the concentrations and return the result
        return ADE_longitudinal_mixing.ADE_Longitudinal_Dispersion(mass,dx,velocity,area,t_settle,self.Analysis.Domain)
        
    def CalculateADETransverseConcentrations(self):
        # extract the information from self.Analysis that it needs to calculate ADE Transverse Concentrations
        mass = self.Analysis.Pollutant.Mass
        depth = self.Analysis.River.Depth
        velocity = self.Analysis.River.MeanVelocity
        dx = self.Analysis.MixingParameters.Dx
        dy = self.Analysis.MixingParameters.Dy
        t_settle = CMF_Hydro.CalculateSettlingTime()
        area = self.Analysis.River.Area

        # calculate the concentrations and return the result
        return ADE_transverse_mixing.ADE_Transverse_Mixing(mass,depth,velocity,area,[dx,dy],t_settle,self.Analysis.Domain)

    def CalculateADZConcentrations(self):
        # extract the information from self.Analysis that it needs to calculate ADZConcentrations
         Co = self.Analysis.Pollutant.ConcentrationsInitial
         tau = self.Analysis.Tau
         t_bar = self.Analysis.TBar
         # calculate the concentrations and return the result
         return ADZ.ADZ(Co, tau, t_bar, self.Analysis.Domain)
    
    def CalculateConcentrations(self):
        self.Analysis.Models.AdvectionOnly.Concentrations = self.CalculateAdvectionOnlyConcentrations()
        self.Analysis.Models.ADELongitudinal.Concentrations = self.CalculateADELongitudinalConcentrations()
        self.Analysis.Models.ADETransverse.Concentrations = self.CalculateADETransverseConcentrations()
        self.Analysis.Models.ADZ.Concentrations = self.CalculateADZConcentrations()
        
    def SetAnalysis(self, AAnalysis):
        self.Analysis = AAnalysis        